<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class HasNoDuplicateFeatures implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if ($this->hasDuplicates($value)) {
            $fail('There are duplicate features, they should have unique names');
        }
    }

    private function hasDuplicates(mixed $value): bool
    {
        return collect($value)->pluck('name')->unique()->count()  < count($value);
    }
}
