<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealerWebReservationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Send vehicle reservation leads to Dealer Web LMS',
                'config_key' => 'dealerweblms-send-reservations',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
