<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class LabelJustArrivedSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Number of days for Just Arrived label',
                'config_key' => 'vehicle-labels-just-arrived-days',
                'type' => 'number',
                'order' => 9,
                'value' => 30,
                'min_tier' => 'standard',
                'description' => 'The number of days until "Just Arrived" will be displayed',
                'validation_rules' => [
                    "required_if:values.vehicle-labels-enabled,true"
                ]
            ],
        ];
    }
}
