<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SkodaSyncTypeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Offer sync',
                'group' => 'Skoda',
                'name' => 'Synchronization type',
                'config_key' => 'stock-skoda-sync-type',
                'type' => 'string',
                'value' => 'vehicle-offers',
                'description' => 'Specifies where data need to be synchronized',
                'choices' => [
                    ['value' => 'vehicle-offers', 'name' => 'Vehicle Offers'],
                    ['value' => 'vehicles', 'name' => 'Vehicle'],
                    ['value' => 'both', 'name' => 'Both: Vehicle Offers and Vehicles'],
                ],
                'order' => 3,
            ],
        ];
    }
}
