<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleStockStatusFilterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Pre sort mixed results by vehicle stock status',
                'config_key' => 'filter-results-order-by-vehicle-type',
                'min_tier' => 'standard',
                'superadmin' => true,
                'type' => 'boolean',
                'value' => false,
                'description' => 'When filtering new vehicles (new stock or mixed new stock and offers),<br/>'
                    . 'initially sort results by stock status and allow additional user-selected sort',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'New vehicle ordering by status',
                'config_key' => 'filter-results-status-order-values',
                'min_tier' => 'standard',
                'superadmin' => true,
                'type' => 'text',
                'value' => 'offer:0,available now:1,coming soon:2,default:3',
                'description' => 'stock_status:order_value,stock_status:order_value',
            ],
        ];
    }
}
