@extends('crm::emails.layout', [
    'subject' => $enquiry->subject ?? 'New Enquiry',
])

@section('content')

    @php
        // TODO: Pull colour variables from Tenant
        $layerLightColour = '#f2f5f7';
        $layerWhiteColour = '#fff';
        $layerAccentColour = '#D2D2D7';
        $primaryColour = '#269ece';
        $textColour = '#1F2424';

        $innerWrapperWidth = '700';
        $contentWrapperWidth = '600';
    @endphp

    @if(!empty($enquiry->intro))
        <tr>
            <td colspan="2">
                <p>{{ $enquiry->intro }}</p>
            </td>
        <tr>
    @endif

    @foreach($enquiry->details as $entry)
        @if(!empty($entry['answer']) && \Illuminate\Support\Str::endsWith($entry['type'], '_id') === false)
            <tr>
                <td width="32%" valign="top" style="border-bottom:1px solid {{ $layerAccentColour }};padding: 10px;">
                    <strong>{{ $entry['question'] }}</strong>
                </td>

                <td width="58%" valign="middle"
                    style="border-bottom:1px solid {{ $layerAccentColour }};padding:10px;">
                    @if($entry['type'] === 'yes_/_no')
                        {{ $entry['answer'] ? 'Yes' : 'No' }}
                    @elseif (!empty($entry['value']))
                        {{ $entry['value'] }}
                    @else
                        {{ is_array($entry['answer']) ? implode(', ', $entry['answer']) : $entry['answer'] }}
                    @endif
                </td>
            </tr>
        @endif
    @endforeach

    @foreach($enquiry->objects as $object)
        @php $enquiry->reason = $object->object @endphp
        <tr>

            <td colspan="2" width="32%" valign="top" style="padding: 20px; border-bottom:1px solid {{ $layerAccentColour }}; text-align: center">
                <strong>{{ ucwords($object->object_type) }}</strong>
            </td>

        </tr>
        @includeIf('emails.enquiry.partials.' . str_replace('-', '_', $object->object_type))
    @endforeach

    <tr>
        <td height="20" colspan="2"></td>
    </tr>

    <tr>
        <td align="center" colspan="2">
            <a href="{{ $enquiry->getViewUrl() }}"
               target="_blank"
               rel="noopener noreferrer"
               style="width:300px; max-width:100%; display:inline-block; text-align:center; text-decoration:none; color:{{ $layerWhiteColour }}; background-color:{{ $primaryColour }}; padding:12px 0; border-radius:5px;"
            >
                View Details in CRM
            </a>
        </td>
    </tr>

    <tr>
        <td height="20" colspan="2"></td>
    </tr>
@endsection
