<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MotordatSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motordat',
                'name' => 'Enabled',
                'config_key' => 'stock-motordat-enabled',
                'type' => 'boolean',
                'min_tier' => 'enterprise',
                'value' => false,
                'description' => 'Sync with MOTORDAT. Relies on custom mapping pattern defined by next setting',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motordat',
                'name' => 'Mapping factory name',
                'config_key' => 'stock-motordat-factory',
                'type' => 'string',
                'min_tier' => 'enterprise',
                'value' => '',
                'superadmin' => true,
                'description' => 'Set the mapping factory pattern to use for MOTORDAT.',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motordat',
                'name' => 'DB Host',
                'config_key' => 'stock-motordat-host',
                'type' => 'string',
                'min_tier' => 'enterprise',
                'value' => '',
                'superadmin' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motordat',
                'name' => 'DB Username',
                'config_key' => 'stock-motordat-username',
                'type' => 'string',
                'min_tier' => 'enterprise',
                'value' => '',
                'superadmin' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motordat',
                'name' => 'DB Password',
                'config_key' => 'stock-motordat-password',
                'type' => 'secret',
                'min_tier' => 'enterprise',
                'value' => '',
                'superadmin' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motordat',
                'name' => 'DB Name',
                'config_key' => 'stock-motordat-database',
                'type' => 'string',
                'min_tier' => 'enterprise',
                'value' => '',
                'superadmin' => true,
            ],
        ];
    }
}
