<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferFinanceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Offers',
                'name' => 'Representative Finance Term',
                'config_key' => 'offers-finance-term',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 60,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Offers',
                'name' => 'Representative Finance Annual Mileage',
                'config_key' => 'offers-finance-annual_mileage',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 10000,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Offers',
                'name' => 'Representative Finance Deposit Percentage',
                'config_key' => 'offers-finance-deposit_percentage',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 10,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Offers',
                'name' => 'Representative Finance Credit rating',
                'config_key' => 'offers-finance-credit_rating',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => 'excellent',
            ],
        ];
    }
}
