<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferMultipleFuelTypes extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'General',
            'group' => 'Offers',
            'name' => 'Multiple fuel types for offer',
            'config_key' => 'offers-multiple-fuel-types',
            'type' => 'boolean',
            'value' => false,
            'superadmin' => true,
            'min_tier' => 'pro',
            'description' => 'Will allow setting multiple fuel types for offer.'
                . ' NB(!) Switching this with pre-populated data changes data fetch from column to table so previous '
                . 'values will become inaccessible',
            'order' => 25,
        ]);
    }
}
