<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterSelectionsOnResultsForWidgetSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Selection based filter results for widget',
                'config_key' => 'filter-apply-selections-to-results-for-widget',
                'type' => 'boolean',
                'value' => false,
                'description' => '',
                'order' => 4,
            ],
        ];
    }
}
