<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class SetDealStatus extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'status_id' => [
                'required',
                'exists:deal_builder_statuses,id',
            ],
        ];
    }
    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            $status = $this->deal?->status;
            Log::debug('deal status', [$status, $this->deal]);
            if ($status->is_final) {
                $validator->errors()->add('status', __('validation.status_cannot_be_changed'));
            }
        });
    }
}
