<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\DealBuilder\AddOn;
use Mtc\MercuryDataModels\DealBuilder\Status;

class DealAddOnList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(AddOn $addOn) => [
            'id' => $addOn->id,
            'title' => $addOn->name,
            'link' => '/manage-content/deal-add-ons/edit/' . $addOn->id,
        ]);
        return parent::toArray($request);
    }
}
