<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\DealBuilder\Deal;

class DealList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(Deal $deal) => $this->mapDeal($deal));
        $resource = $this->resource->toArray();
        $resource['default_columns'] = [
            'status',
        ];
        return $resource;
    }

    private function mapDeal(Deal $deal)
    {
        return [
            'image' => [
                'src' => $deal->vehicle?->getPreviewImage('mini-thumb'),
                'alt' => $deal->vehicle?->title,
            ],
            'title' => $deal->customer?->name,
            'description' => collect([
                $deal->vehicle?->colour,
                $deal->vehicle?->make->name,
                $deal->vehicle?->model->name,
                $deal->vehicle?->derivative,
                $deal->vehicle?->reginstraion_number,
            ])->implode(' '),
            'metaItems' => [
                'status' => $deal->status_id > 0
                    ? $deal->status?->name ?? __('labels.unknown_status')
                    : __('labels.draft'),
            ],
            'link' => '/manage-content/deals/edit/' . $deal->id,
            'uuid' => $deal->reference,
            'id' => $deal->id,

        ];
    }
}
