<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\DealBuilder\Status;

class DealStatusList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(Status $status) => [
            'id' => $status->id,
            'title' => $status->name,
            'link' => $status->editable ? '/manage-content/deal-statuses/edit/' . $status->id : '',
            'metaItems' => [
                'is_final' => $status->is_final,
            ],
        ]);
        return parent::toArray($request);
    }
}
