<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\DealBuilder\DealHistory;

class NewDealCustomerStatusChangeJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(private readonly int $history_id)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $history = DealHistory::query()->findOrFail($this->history_id);
        if ($history->notification_sent_at) {
            return;
        }
    }
}
