<?php

namespace App\Jobs;

use App\Facades\Settings;
use App\Services\DealerWebLmsApi;
use App\Services\EnquiryMaxApi;
use App\Services\SalesforceCrmApi;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;

class ProcessIncomingReservationJob extends \Mtc\VehicleReservations\Jobs\ProcessIncomingReservationJob
{
    protected function process(): bool
    {
        if (Settings::get('crm-enquiry-max-send-reservations')) {
            try {
                App::make(EnquiryMaxApi::class)->sendReservation($this->reservation);
            } catch (\Exception $exception) {
                Log::error(tenant('id') . ' failed to export reservation to enquiryMax', [$exception->getMessage()]);
            }
        }

        if (Settings::get('dealerweblms-send-reservations')) {
            try {
                App::make(DealerWebLmsApi::class)->sendReservation($this->reservation);
            } catch (\Exception $exception) {
                Log::error(tenant('id') . ' failed to export reservation to DealerWeb', [$exception->getMessage()]);
            }
        }

        if (Settings::get('salesforce-crm-send-reservations')) {
            try {
                App::make(SalesforceCrmApi::class)->sendReservation($this->reservation);
            } catch (\Exception $exception) {
                Log::error(tenant('id') . ' failed to export reservation to Salesforce', [$exception->getMessage()]);
            }
        }

        return $this->sendConfirmation();
    }
}
