<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\DealBuilder\Deal;

class ProcessNewDealSubmissionJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(private readonly int $deal_id)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $deal = Deal::query()->findOrFail($this->deal_id);
        if ($deal->ingested_at) {
            return;
        }
    }
}
