<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Colour;

class ColourMapSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Filter',
            'group' => 'General',
            'name' => 'Use colour mapping',
            'config_key' => 'filter-use-colour-mapping',
            'type' => 'boolean',
            'value' => false,
            'min_tier' => 'standard',
            'description' => 'When enabled filter will use colour map table instead of specific vehicle colour names.<br/>'
                . ' Useful for handling branded colours like "Midnight black" and "Onyx black" to be a simple "Black" filter.<br/>'
                . '<a href="/settings/colour-map">Go to colour mapping</a>',
            'order' => 2,
        ]);

        collect($this->getData())
            ->each(fn($colour) => Colour::query()->create($colour));
    }

    private function getData()
    {
        return [
            ['colour' => 'Black'],
            ['colour' => 'White'],
            ['colour' => 'Blue'],
            ['colour' => 'Red'],
            ['colour' => 'Green'],
            ['colour' => 'Silver'],
            ['colour' => 'Gray'],
            ['colour' => 'Yellow'],
            ['colour' => 'Brown'],
            ['colour' => 'Pink'],
            ['colour' => 'Beige'],
            ['colour' => 'Multicolour'],
        ];
    }
}
