<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class RapidRTCSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop Leads',
                'name' => 'Enabled',
                'config_key' => 'crm-rapid-rtc-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => '<a href="https://www.keyloop.com/marketing/keyloop-leads" target="_blank">Keyloop Leads</a> '
                    . ' integration. Once enabled will add additional fields against manage dealership.',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop Leads',
                'name' => 'Verify integration',
                'config_key' => 'crm-rapid-rtc-verify',
                'type' => 'verify',
                'value' => false,
                'description' => '',
            ],
        ];
    }
}
