<?php

namespace App\Console\Commands;

use App\Jobs\RunScheduledSyncTask;
use App\Jobs\RunSilverBulletExport;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Tenant;

class ExportToSilverBullet extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'export:silver-bullet';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Export vehicle data to SilverBullet';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->dispatch(new RunSilverBulletExport(tenant()));
        return 0;
    }
}
