<?php

namespace App\Http\Controllers;

use App\Http\Requests\AutoTraderHubNotification;
use App\Jobs\HandleAutoTraderHubNotification;
use Illuminate\Foundation\Bus\DispatchesJobs;

class AutoTraderHubNotificationController extends Controller
{
    use DispatchesJobs;

    public function store(AutoTraderHubNotification $request)
    {
        $this->dispatch(new HandleAutoTraderHubNotification($request->input()));

        return response([
            'status' => 'received'
        ]);
    }
}
