<?php

namespace App\Http\Controllers;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Mtc\MercuryDataModels\BodyStyleType;

class BodyStyleController extends Controller
{
    /**
     * Display a listing of body styles
     *
     * @return LengthAwarePaginator
     */
    public function index()
    {
        return BodyStyleType::query()->orderBy('name')->paginate();
    }

    /**
     * Display the specified body style.
     *
     * @param  int  $id
     * @return BodyStyleType
     */
    public function show(BodyStyleType $body_style)
    {
        return $body_style;
    }
}
