<?php

namespace App\Http\Controllers;

use App\Http\Resources\FranchiseList;
use App\Http\Resources\FranchiseView;
use Illuminate\Http\Request;
use Mtc\ContentManager\Facades\Media;
use Mtc\MercuryDataModels\Franchise;

class FranchiseController extends Controller
{
    public function __construct()
    {
        $this->middleware([
            'permission:edit-franchises',
        ]);
    }

    public function index(Request $request)
    {
        $franchises = Franchise::query()
            ->with('make')
            ->setSortBy($request->input('sort_by', 'id_desc'))
            ->setFilters($request->input('filters', []))
            ->when(
                $request->filled('search_term'),
                function ($query) use ($request) {
                    $query->where('name', 'like', '%' . $request->input('search_term') . '%');
                }
            )
            ->paginate();

        return new FranchiseList($franchises);
    }

    public function show(Franchise $franchise)
    {
        return new FranchiseView($franchise);
    }

    public function store(Request $request)
    {
        return Franchise::query()->create($request->input());
    }

    public function update(Request $request, Franchise $franchise)
    {
        $franchise->fill($request->input());
        $franchise->slug = $request->input('seo.slug') ?? $franchise->slug;
        $franchise->save();
        Media::setUsesForModel($request->input('media', []), $franchise, ['primary' =>  true], false);
        Media::setUsesForModel($request->input('square_logo', []), $franchise, ['flags' => ['square' => true]], false);
        $allMedia = array_merge(
            $request->input('media', []),
            $request->input('square_logo', [])
        );
        Media::removeMediaUsesNotInList($franchise, $allMedia);

        return new FranchiseView($franchise);
    }

    public function destroy(Franchise $franchise)
    {
        return $franchise->delete();
    }

    public function copy(Request $request, Franchise $franchise): FranchiseView
    {
        $data = $franchise->toArray();
        $data['name'] = $request->input('name');
        unset($data['slug']);
        $copy = Franchise::query()->create($data);
        return new FranchiseView($copy);
    }
}
