<?php

namespace App\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Str;
use Mtc\Crm\Contracts\EnquiryModel;

class EnquiryList extends \Mtc\Crm\Http\Resources\EnquiryList
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource
                ->through(fn(EnquiryModel $enquiry) => $this->mapEntry($enquiry));
        } else {
            $this->resource = $this->resource
                ->map(fn(EnquiryModel $enquiry) => $this->mapEntry($enquiry));
        }
        $resource = $this->resource->toArray();
        $resource['filters'] = [
            [
                'name' => 'Partially submitted',
                'value' => 'partiallySubmitted',
            ],
            [
                'name' => 'Archived',
                'value' => 'archived',
            ],
        ];
        return $resource;
    }

    private function mapEntry(EnquiryModel $enquiry)
    {
        return [
            'id' => $enquiry->id,
            'title' => $enquiry->title,
            'metaItems' => [
                $enquiry->form?->name,
                $enquiry->actions
                    ->map(function ($action) {
                        if ($action->processed_at) {
                            return Str::title(str_replace('-', ' ', $action->action_name)) . ' - OK';
                        }
                        if ($action->failed_at) {
                            return Str::title(str_replace('-', ' ', $action->action_name)) . ' - Failed';
                        }
                        return Str::title(str_replace('-', ' ', $action->action_name)) . ' - Pending';
                    })->implode('<br/>'),
            ]
        ];
    }
}
