<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\AutowebExportJob;
use App\Jobs\CarzoneExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class Carzone implements SalesChannel
{
    use DispatchesJobs;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-carzone-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.carzone');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled()) {
            $this->dispatch(new CarzoneExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'carzone-dealer-id' => [
                'type' => 'text',
                'validation' => [
                    'required',
                ],
                'label' => 'Dealership name on Carzone'
            ],
        ];
    }
}
