<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderRemoveVehiclesSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Remove vehicles when they no longer are on AutoTrader feed',
                'config_key' => 'auto-trader-stock-remove-old-vehicles',
                'type' => 'boolean',
                'value' => true,
                'description' => '.',
                'order' => 22,
            ],
        ];
    }
}
