#!/bin/sh

# entry point is latest release folder, NEW_RELEASE is the var being passed from bitbucket-pipelines.yml
# This can be manually passed by running 'bash deploy.sh 'varhere'
NEW_RELEASE=$1

ENVIRONMENT=$2

CURRENT_DIR=${PWD}
BASE_PATH=$(dirname $(dirname "$CURRENT_DIR"))

# Symlink .env and robots files
ln -s "$BASE_PATH"/.env "$BASE_PATH"/releases/"$NEW_RELEASE"/.env
ln -s "$BASE_PATH"/robots.txt "$BASE_PATH"/releases/"$NEW_RELEASE"/robots.txt

# Set storage path
rm -rf "$BASE_PATH"/releases/"$NEW_RELEASE"/storage
ln -s "$BASE_PATH"/storage "$BASE_PATH"/releases/"$NEW_RELEASE"/storage


# Go to the new release and run all the necessary commands
cd "$BASE_PATH"/releases/"$NEW_RELEASE" || exit 1

php artisan migrate --force

# Composer install
if [ $ENVIRONMENT == 'production' ]; then
    composer install --no-interaction --no-dev --prefer-dist --optimize-autoloader
else
    composer install
fi

# Secondary migrations from package changes
php artisan deploy

#php artisan storage:link
#php artisan config:cache
#php artisan route:cache
#php artisan event:cache
#php artisan cache:clear


# Go back home
cd "$BASE_PATH" || exit 1

# remove current symlink
unlink "$BASE_PATH"/public_html
unlink "$BASE_PATH"/current-build

# Create symlink to latest release
ln -s "$BASE_PATH"/releases/"$NEW_RELEASE"/public/ "$BASE_PATH"/public_html
# Disabled for security purposes
#ln -s "$BASE_PATH"/phpMyAdmin-etgwrtgwq4rg "$BASE_PATH"/releases/"$NEW_RELEASE"/public/phpMyAdmin-etgwrtgwq4rg
ln -s "$BASE_PATH"/releases/"$NEW_RELEASE" "$BASE_PATH"/current-build

# Go back to release
cd "$CURRENT_DIR" || exit 1

# send queue restart signal to make sure workers use the new code
php artisan queue:restart

# Drop old build processes
php drop_old_builds.php $NEW_RELEASE
