<?php

namespace Tests\Feature;

use App\Models\Report;
use App\Schedule\BiWeekly;
use App\Schedule\Daily;
use App\Schedule\Monthly;
use App\Schedule\Weekly;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Tests\UserForTenant;

class ScheduleTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testBiWeekly()
    {
        $report = Report::factory()->create([
            'export_time' => '08:00',
            'export_day_of_week' => 2,
        ]);

        // Reloading because factory generates parent class not App namespace
        /** @var Report $report */
        $report = Report::query()->find($report->id);

        $result = (new BiWeekly())->nextTime(Carbon::create(2023, 5), $report);
        $this->assertEquals('2023-05-16 08:00', $result->format('Y-m-d H:i'));

        $report->export_time = '17:30';
        $report->export_day_of_week = 6;
        $result = (new BiWeekly())->nextTime(Carbon::create(2023, 5), $report);
        $this->assertEquals('2023-05-20 17:30', $result->format('Y-m-d H:i'));
    }

    public function testDaily()
    {
        $report = Report::factory()->create([
            'export_time' => '08:00',
        ]);

        // Reloading because factory generates parent class not App namespace
        /** @var Report $report */
        $report = Report::query()->find($report->id);

        $result = (new Daily())->nextTime(Carbon::create(2023, 5), $report);
        $this->assertEquals('2023-05-02 08:00', $result->format('Y-m-d H:i'));
        $result = (new Daily())->nextTime(Carbon::create(2023, 5, 10), $report);
        $this->assertEquals('2023-05-11 08:00', $result->format('Y-m-d H:i'));
    }

    public function testMonthly()
    {
        $report = Report::factory()->create([
            'export_time' => '08:00',
            'export_day_of_month' => 2,
        ]);

        // Reloading because factory generates parent class not App namespace
        /** @var Report $report */
        $report = Report::query()->find($report->id);

        $result = (new Monthly())->nextTime(Carbon::create(2023, 5), $report);
        $this->assertEquals('2023-06-02 08:00', $result->format('Y-m-d H:i'));

        $report->export_time = '17:30';
        $report->export_day_of_month = 6;
        $result = (new Monthly())->nextTime(Carbon::create(2023, 5), $report);
        $this->assertEquals('2023-06-06 17:30', $result->format('Y-m-d H:i'));
    }

    public function testWeekly()
    {
        $report = Report::factory()->create([
            'export_time' => '08:00',
            'export_day_of_week' => 2,
        ]);

        // Reloading because factory generates parent class not App namespace
        /** @var Report $report */
        $report = Report::query()->find($report->id);

        $result = (new Weekly())->nextTime(Carbon::create(2023, 5), $report);
        $this->assertEquals('2023-05-09 08:00', $result->format('Y-m-d H:i'));

        $report->export_time = '17:30';
        $report->export_day_of_week = 6;
        $result = (new Weekly())->nextTime(Carbon::create(2023, 5), $report);
        $this->assertEquals('2023-05-13 17:30', $result->format('Y-m-d H:i'));
    }
}
