<?php

namespace App\Http\Resources;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use Mtc\ContentManager\Contracts\PageModel;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\VehicleOffer;

class FranchiseUsageListResource extends JsonResource
{
    public static $wrap = '';
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        if ($this->resource instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator) {
            $this->resource
                ->through(fn(Model $entry) => $this->mapRecord($entry));
        } else {
            $this->resource = $this->resource
                ->map(fn(Model $entry) => $this->mapRecord($entry));
        }
        return parent::toArray($request);
    }

    /**
     * Map template record
     *
     * @param Model $page
     * @return array
     */
    protected function mapRecord(Model $entry)
    {
        if ($entry instanceof PageModel) {
            return [
                'id' => $entry->id,
                'title' => $entry->title,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/content/edit/' . $entry->id,
                'type' => 'page',
            ];
        }

        if ($entry instanceof Dealership) {
            return [
                'id' => $entry->id,
                'title' => $entry->name,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/dealerships/edit/' . $entry->id,
                'type' => 'dealership',
            ];
        }


        if ($entry instanceof VehicleOffer) {
            return [
                'id' => $entry->id,
                'title' => $entry->name,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/offers/edit/' . $entry->id,
                'type' => 'offer',
            ];
        }


        if ($entry instanceof NewCar) {
            return [
                'id' => $entry->id,
                'title' => $entry->name,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/new-vehicles/edit/' . $entry->id,
                'type' => 'new vehicle',
            ];
        }

        return [
            'id' => $entry->id,
            'title' => $entry->title,
            'updated_at' => $entry->updated_at->diffForHumans(),
            'url' => '/manage-content/navigation/edit/' . $entry->id,
            'type' => 'navigation menu',
        ];
    }
}
