<?php

namespace App\Http\Resources;

use App\TierHelper;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Str;
use JsonSerializable;

class SiteDomainListResource extends JsonResource
{
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource = $this->resource->map(fn ($domain) => [
            'id' => $domain->id,
            'domain' => $domain->domain,
            'verified' => $domain->verified,
            'ssl_verified' => $domain->ssl_verified,
            'primary' => $domain->primary,
            'temporary' => $domain->temporary,
            'force' => $domain->force,
        ]);
        return parent::toArray($request);
    }
}
