<?php

namespace App\Master\Http\Requests;

use JetBrains\PhpStorm\ArrayShape;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class RemoveUserFromSiteRequest extends SiteRequest
{
    use CentralConnection;

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    #[ArrayShape(['userId' => "string[]"])] public function rules()
    {
        $global = $this->getConnectionName();
        return [
            'userId' => [
                'required',
                "exists:$global.users,id",
            ]
        ];
    }
}
