<?php

namespace App\Master\Http\Resources;

use App\TierHelper;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use JsonSerializable;
use Symfony\Component\Intl\Currencies;

class SiteListResource extends JsonResource
{
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource = $this->resource
            ->through(fn($site) => [
                'id' => $site->id,
                'name' => $site->name,
                'is_suspended' => $site->is_suspended,
                'domains' => $site->domains->pluck('domain'),
                'tier' => $site->tier,
                'user_limit' => TierHelper::userLimit($site->tier),
                'currency' => Currencies::getSymbol($site->currency ?? 'GBP'),
                'features' => $site->features->pluck('feature'),
                'users' => $site->users->map(fn($user) => [
                    'id' => $user->id,
                    'name' => $user->name,
                    'email' => $user->email,
                    'profile_photo_url' => $user->profile_photo_url,
                    'role' => $user->pivot->role,
                ])
            ]);

        return parent::toArray($request);
    }
}
