<?php

namespace App\Modules\Stock;

use App\Contracts\ExternalMediaUrlProvider;
use App\Contracts\StockProvider;
use App\Facades\Settings;
use App\Imports\PeterVardyMotordatToVehicleImport;
use Mtc\ContentManager\Contracts\Media;

class Motordat implements ExternalMediaUrlProvider, StockProvider
{
    public function url(Media $media, string $size): string
    {
        $size = $this->mapImageDimensions($size);
        return "https://motordat-img-1.motordat.com/images/$size/" . ltrim($media->src, '/');
    }
    public function enabled(): bool
    {
        return (Settings::get('stock-motordat-enabled') ?? false)
            && !empty(Settings::get('stock-motordat-factory'));
    }

    public function name(): string
    {
        return 'Motordat';
    }

    public function runScheduledImport(): void
    {
        match (Settings::get('stock-motordat-factory')) {
            'peter-vardy' => (new PeterVardyMotordatToVehicleImport())->syncVehicles(),
            default => null,
        };
    }

    private function mapImageDimensions(string $size): string
    {
        return match ($size) {
            'smallthumbs' => 'smallthumbs',
            'thumbs' => 'thumbs',
            'original' => 'verylarge',
            default => 'large',
        };
    }
}
