<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\Crm\Facades\EnquiryData;

class EnquiryTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->entries())
            ->each(fn(string $entry) => EnquiryData::addType($entry));
    }

    private function entries(): array
    {
        return [
            'General Contact Enquiry',
            'Vehicle Enquiry',
            'Offer Enquiry',
            'Test Drive',
            'Service',
        ];
    }
}
