<?php

namespace Tests\Feature;

use App\Reporting\EnquiryCountTile;
use App\Reporting\StatsModels\EnquiriesPerDay;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Models\Enquiry;
use Mtc\MercuryDataModels\ReportingStat;
use Tests\TestCase;

class EnquiryCountTileTest extends TestCase
{
    use RefreshDatabase;
    protected $tenancy = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testGeneratesEnquiryCountStats()
    {
        Enquiry::factory(10)->create(['created_at' => Carbon::now()->subDay()]);
        Enquiry::factory(5)->create(['created_at' => Carbon::now()->subDays(40)]);

        $stats = new EnquiriesPerDay();

        $this->assertEquals('enquiries', $stats->getKey());
        $this->assertEquals(10, $stats->getValue(Carbon::yesterday()));
        $this->assertEquals(5, $stats->getValue(Carbon::now()->subDays(40)));
        $this->assertEquals(0, $stats->getValue(Carbon::now()));
    }

    public function testGetsEnquiryCountStatsIncreased()
    {
        ReportingStat::factory(3)->create([
            'key' => 'enquiries',
            'date' => Carbon::now()->subDay(),
            'value' => 5
        ]);
        ReportingStat::factory(3)->create([
            'key' => 'enquiries',
            'date' => Carbon::now()->subDays(40),
            'value' => 4
        ]);

        $stats = new EnquiryCountTile();

        $this->assertEquals('Number of Enquiries', $stats->name());
        $this->assertEquals(15, $stats->value());
        $this->assertEquals(12, $stats->secondaryValue());
        $this->assertEquals('25%', $stats->difference());
    }

    public function testGetsEnquiryCountStatsDecreased()
    {
        ReportingStat::factory(3)->create([
            'key' => 'enquiries',
            'date' => Carbon::now()->subDay(),
            'value' => 25
        ]);
        ReportingStat::factory(3)->create([
            'key' => 'enquiries',
            'date' => Carbon::now()->subDays(40),
            'value' => 35
        ]);

        $stats = new EnquiryCountTile();
        $this->assertEquals('-29%', $stats->difference());
    }
}
