<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Mtc\MercuryDataModels\ContentElement;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Form;
use Mtc\MercuryDataModels\Franchise;
use Mtc\MercuryDataModels\Label;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\PropertyCategory;
use Mtc\MercuryDataModels\Template;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TestCase;
use Tests\UserForTenant;

class OptionListTest extends TestCase
{
    use DatabaseMigrations;
    use UserForTenant;

    protected $tenancy = true;

    public function testDealerships()
    {
        $model = Dealership::factory()->create(['name' => 'foo']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'dealerships'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testFranchises()
    {
        $model = Franchise::factory()->create(['name' => 'foo']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'franchises'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testMakes()
    {
        $model = VehicleMake::factory()->create(['name' => 'foo']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'makes'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testPages()
    {
        $model = Page::factory()->create(['title' => 'foo', 'status' => 'published']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'pages'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testTemplates()
    {
        $model = Template::factory()->create(['name' => 'foo', 'status' => 'published']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'templates'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testElements()
    {
        $model = ContentElement::factory()->create(['title' => 'foo']);
        $model2 = ContentElement::factory()->create(['title' => 'foo', 'category' => 'baz']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'elements'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testForms()
    {
        $model = Form::factory()->create(['name' => 'foo', 'is_active' => true]);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'forms'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testBlogPages()
    {
        $model = Page::factory()->create(['title' => 'foo', 'category' => 'blog']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'blog-pages'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testNewsPages()
    {
        $model = Page::factory()->create(['title' => 'foo', 'category' => 'news']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'news-pages'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testOffers()
    {
        $model = VehicleOffer::factory()->create(['name' => 'foo']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'offers'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testVehicles()
    {
        $model = Vehicle::factory()->create();
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'vehicles'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
    }
    public function testTaxonomies()
    {
        $model = PropertyCategory::factory()->create(['name' => 'foo', 'active' => 1]);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'taxonomies'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
    public function testLabels()
    {
        $model = Label::factory()->create(['name' => 'foo']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.data-list', 'labels'));
        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('id', $response->json('0'));
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertEquals($model->id, $response->json('0.id'));
        $this->assertEquals('foo', $response->json('0.name'));
    }
}
