<?php

namespace Tests\Feature;

use App\Console\Commands\RemoveOrphanedVehicleData;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Label;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleAttributeValue;
use Mtc\MercuryDataModels\VehicleAutoTraderData;
use Mtc\MercuryDataModels\VehicleFeature;
use Mtc\MercuryDataModels\VehicleFinance;
use Mtc\MercuryDataModels\VehicleLabel;
use Mtc\MercuryDataModels\VehicleStandardEquipment;
use Mtc\MercuryDataModels\VehicleTechnicalData;
use Mtc\MercuryDataModels\VehicleView;
use Tests\TestCase;

class RemoveOrphanedVehicleDataCommandTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testRemoveOrphanedVehicleData()
    {
        // create the test data

        $existing_vehicle_id = 123;
        $hard_deleted_vehicle_id = 456;

        Vehicle::factory()->create([
            'id' => $existing_vehicle_id,
        ]);

        $this->createData($existing_vehicle_id);
        $this->createData($hard_deleted_vehicle_id);

        // assert we have the expected data
        $this->assertCount(2, VehicleAttributeValue::all());
        $this->assertCount(2, VehicleAutoTraderData::all());
        $this->assertCount(2, VehicleFeature::all());
        $this->assertCount(2, VehicleFinance::all());
        $this->assertCount(2, VehicleLabel::all());
        $this->assertCount(2, VehicleStandardEquipment::all());
        $this->assertCount(2, VehicleTechnicalData::all());
        $this->assertCount(2, VehicleView::all());

        $this->assertCount(1, VehicleAttributeValue::query()->where('owner_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleAutoTraderData::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleFeature::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleFinance::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleLabel::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleStandardEquipment::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleTechnicalData::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleView::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());

        $this->assertCount(1, VehicleAttributeValue::query()->where('owner_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(1, VehicleAutoTraderData::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(1, VehicleFeature::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(1, VehicleFinance::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(1, VehicleLabel::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(1, VehicleStandardEquipment::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(1, VehicleTechnicalData::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(1, VehicleView::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());

        // run the clean up command
        $command = $this->artisan(RemoveOrphanedVehicleData::class);
        $command->run();

        // assert that the expected data has been removed
        $this->assertCount(1, VehicleAttributeValue::all());
        $this->assertCount(1, VehicleAutoTraderData::all());
        $this->assertCount(1, VehicleFeature::all());
        $this->assertCount(1, VehicleFinance::all());
        $this->assertCount(1, VehicleLabel::all());
        $this->assertCount(1, VehicleStandardEquipment::all());
        $this->assertCount(1, VehicleTechnicalData::all());
        $this->assertCount(1, VehicleView::all());

        $this->assertCount(1, VehicleAttributeValue::query()->where('owner_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleAutoTraderData::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleFeature::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleFinance::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleLabel::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleStandardEquipment::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleTechnicalData::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());
        $this->assertCount(1, VehicleView::query()->where('vehicle_id', '=', $existing_vehicle_id)->get());

        $this->assertCount(0, VehicleAttributeValue::query()->where('owner_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(0, VehicleAutoTraderData::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(0, VehicleFeature::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(0, VehicleFinance::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(0, VehicleLabel::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(0, VehicleStandardEquipment::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(0, VehicleTechnicalData::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
        $this->assertCount(0, VehicleView::query()->where('vehicle_id', '=', $hard_deleted_vehicle_id)->get());
    }

    private function createData($vehicle_id)
    {
        VehicleAttributeValue::factory()->create([
            'owner_type' => 'vehicle',
            'owner_id' => $vehicle_id,
        ]);

        VehicleAutoTraderData::factory()->create([
            'vehicle_id' => $vehicle_id,
        ]);

        VehicleFeature::factory()->create([
            'vehicle_id' => $vehicle_id,
            'vehicle_type' => 'vehicle',
        ]);

        VehicleFinance::factory()->create([
            'vehicle_id' => $vehicle_id,
        ]);

        $label = Label::factory()->create();

        VehicleLabel::query()->create([
            'vehicle_id' => $vehicle_id,
            'label_id' => $label->id,
        ]);

        VehicleStandardEquipment::factory()->create([
            'vehicle_id' => $vehicle_id,
            'vehicle_type' => 'vehicle',
        ]);

        VehicleTechnicalData::factory()->create([
            'vehicle_id' => $vehicle_id,
            'vehicle_type' => 'vehicle',
        ]);

        VehicleView::query()->create([
            'vehicle_id' => $vehicle_id,
            'date' => Carbon::now()->format('Y-m-d')
        ]);
    }
}
