<?php

namespace App;

use App\Contracts\InteractsWithContentSync;
use Mtc\ContentManager\Models\ContentTag;

class ContentTagRepository implements InteractsWithContentSync
{
    public function importRecord(array $entry): bool
    {
        $contentTag = ContentTag::query()->create($entry);

        return $contentTag->exists;
    }

    public function canBeImported(array $entry): bool
    {
        return !ContentTag::query()
            ->where('slug', $entry['slug'])
            ->exists();
    }

    public function exportToRemote(array $selections): array
    {
        return ContentTag::query()
            ->select([
                'name',
                'slug',
            ])
            ->whereIn('id', $selections)
            ->get()
            ->toArray();
    }

    public function checkImportEntryValidity(array $dataEntry, array $allEntries): array
    {
        $errors = [];

        if (empty($dataEntry['slug'])) {
            $errors[] = __('validation.import_slug_missing', ['slug' => $dataEntry['slug']]);
        } elseif (ContentTag::query()->where('slug', $dataEntry['slug'])->exists()) {
            $errors[] = __('validation.import_slug_taken', ['slug' => $dataEntry['slug']]);
        }

        return [
            'data' => $dataEntry,
            'errors' => $errors,
        ];
    }
}
