<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\AutowebExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class Autoweb implements SalesChannel
{
    use DispatchesJobs;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-autoweb-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.autoweb');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled()) {
            $this->dispatch(new AutowebExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'autoweb-dealer-id' => [
                'type' => 'text',
                'validation' => [
                ],
                'label' => 'SellerID on Autoweb'
            ],
            'autoweb-api-key' => [
                'type' => 'text',
                'validation' => [
                ],
                'label' => 'Autoweb API Key'
            ],
        ];
    }
}
