<?php

namespace App\Crm;

use App\Contracts\AddsDealershipFields;
use App\Contracts\ForwardsReservationToCrm;
use App\Facades\Settings;
use App\Services\DealerWebLmsApi;
use App\Services\FuseCrmApi;
use Illuminate\Support\Facades\App;
use Mtc\Crm\Contracts\EnquiryAction;
use Mtc\Crm\Contracts\EnquiryActionModel;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\VehicleReservations\Reservation;

class SendEnquiryToFuse implements EnquiryAction, ForwardsReservationToCrm
{
    use CheckForExpiredAction;

    public function __construct(private readonly FuseCrmApi $api)
    {
        //
    }

    public function enabled(): bool
    {
        return Settings::get('fuse-crm-enabled') === true;
    }

    /**
     * Data fields to add to form
     *
     * @return array
     */
    public function formAdditionalDataFields(): array
    {
        return [];
    }

    /**
     * Data fields to add to questions
     *
     * @return array[]
     */
    public function formQuestionDataFields(): array
    {
        return [
            'fuse-field' => [
                'type' => 'select',
                'label' => 'Field mapped against Fuse CRM',
                'choices' => [
                    'title' => 'Title',
                    'forename' => 'Forename',
                    'surname' => 'Surname',
                    'company_name' => 'Company Name',
                    'phone' => 'Mobile Phone Number',
                    'landline' => 'Home Phone Number',
                    'email' => 'Email Address',
                    'customer_comments' => 'Message/Comments',

                    'houseNameNo' => 'House Name/No.',
                    'street' => 'Street',
                    'locale' => 'Suburb/Locale/District',
                    'city' => 'City',
                    'postcode' => 'Postcode',

                    'terms_agreed' => 'Whether customer has agreed to terms',
                    'preferredContactMethods' => 'Preferred means of contact',

                    'utm_campaign' => 'UTM Campaign',
                    'utm_content' => 'UTM Content',
                    'utm_medium' => 'UTM Medium',
                    'utm_source' => 'UTM Source',
                    'utm_term' => 'UTM Term',
                    'search_engine' => 'The search engine the user came from.',
                ],
            ]
        ];
    }

    /**
     * Handle the action
     *
     * @param EnquiryActionModel $action
     * @param EnquiryModel $enquiry
     * @return bool
     */
    public function handle(EnquiryActionModel $action, EnquiryModel $enquiry): ?bool
    {
        if ($this->expired($action)) {
            return null;
        }

        return $this->api->sendLead($enquiry, $action);
    }

    public function sendReservation(Reservation $reservation): bool
    {
        if ($this->api->sendReservation($reservation)) {
            $reservation->update(['crm_reference' => $this->api->getResponseAttribute('enquiryId')]);
            return true;
        }
        return false;
    }

    /**
     * Message when successfully processed
     *
     * @return string
     */
    public function successDetails(): string
    {
        return __('crm.lead_registered_with_reference', [
            'reference' => $this->api->getResponseAttribute('enquiryId'),
        ]);
    }

    /**
     * Message when failure detected
     *
     * @return string
     */
    public function failureReason(): string
    {
        return $this->api->getResponseAttribute('error_description') ?? 'Unknown error';
    }
}
