<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Contracts\SearchableModel;

class SearchResponse extends JsonResource
{
    public static $wrap = '';
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $resource = [];
        $this->resource = $this->resource
            ->map(fn (SearchableModel $model) => [
                'name' => $model->getSearchNameAttribute(),
                'description' => $model->getSearchExcerptAttribute(),
                'icon' => null,
                'route' => $model->getSearchResultRoute(),
            ]);
        $resource['data'] =  parent::toArray($request);
        $resource['search_types'] = [
            [
                'name' => 'All',
                'value' => 'all',
            ],
            [
                'name' => 'Enquiries',
                'value' => 'enquiry',
            ],
            [
                'name' => 'Vehicles',
                'value' => 'vehicle',
            ],
            [
                'name' => 'Content pages',
                'value' => 'page',
            ],
            [
                'name' => 'New vehicles',
                'value' => 'new-car',
            ],
            [
                'name' => 'Vehicle offers',
                'value' => 'offer',
            ],
            [
                'name' => 'Global content',
                'value' => 'global',
            ],
            [
                'name' => 'Navigation menus',
                'value' => 'menu',
            ],
            [
                'name' => 'Dealerships',
                'value' => 'dealership',
            ],
            [
                'name' => 'Forms',
                'value' => 'form',
            ],
        ];
        return $resource;
    }
}
