<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class HPISettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'HPI',
                'name' => 'Enabled',
                'config_key' => 'vehicle-spec-providers-hpi-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'pro',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'HPI',
                'name' => 'Customer Code',
                'config_key' => 'vehicle-spec-providers-hpi-customer_code',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.vehicle-spec-providers-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'HPI',
                'name' => 'Password',
                'config_key' => 'vehicle-spec-providers-hpi-password',
                'type' => 'secret',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.vehicle-spec-providers-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'HPI',
                'name' => 'Initials',
                'config_key' => 'vehicle-spec-providers-hpi-initials',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.vehicle-spec-providers-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'HPI',
                'name' => 'Primary product code',
                'config_key' => 'vehicle-spec-providers-hpi-primary_product_code',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'description' => 'Note that multiple products can deliver vehicle specs but the lookup costs can vary '
                    . 'significantly. Ensure that the correct product code is used.',
                'validation_rules' => [
                    "required_if:values.vehicle-spec-providers-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'HPI',
                'name' => 'Supplementary product code',
                'config_key' => 'vehicle-spec-providers-hpi-supplementary_product_code',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'description' => 'Some product codes require a supplementary product code to be specified.'
                    . ' Ensure that the correct codes are used.',
            ],

            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'HPI',
                'name' => 'Enabled',
                'config_key' => 'lookup-hpi-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'pro',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'HPI',
                'name' => 'Customer Code',
                'config_key' => 'lookup-hpi-customer_code',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.lookup-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'HPI',
                'name' => 'Password',
                'config_key' => 'lookup-hpi-password',
                'type' => 'secret',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.lookup-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'HPI',
                'name' => 'Initials',
                'config_key' => 'lookup-hpi-initials',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.lookup-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'HPI',
                'name' => 'Primary product code',
                'config_key' => 'lookup-hpi-primary_product_code',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'description' => 'Note that multiple products can deliver vehicle specs but the lookup costs can vary '
                    . 'significantly. Ensure that the correct product code is used.',
                'validation_rules' => [
                    "required_if:values.lookup-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'HPI',
                'name' => 'Supplementary product code',
                'config_key' => 'lookup-hpi-supplementary_product_code',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'description' => 'Some product codes require a supplementary product code to be specified.'
                    . ' Ensure that the correct codes are used.',
            ],

            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'HPI',
                'name' => 'Enabled',
                'config_key' => 'valuation-hpi-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'pro',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'HPI',
                'name' => 'Customer Code',
                'config_key' => 'valuation-hpi-customer_code',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.valuation-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'HPI',
                'name' => 'Password',
                'config_key' => 'valuation-hpi-password',
                'type' => 'secret',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.valuation-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'HPI',
                'name' => 'Initials',
                'config_key' => 'valuation-hpi-initials',
                'type' => 'string',
                'value' => '',
                'min_tier' => 'pro',
                'validation_rules' => [
                    "required_if:values.valuation-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'HPI',
                'name' => 'Primary product code',
                'config_key' => 'valuation-hpi-primary_product_code',
                'type' => 'string',
                'value' => 'HPI64',
                'min_tier' => 'pro',
                'description' => 'Note that multiple products can deliver vehicle specs but the lookup costs can vary '
                    . 'significantly. Ensure that the correct product code is used.',
                'validation_rules' => [
                    "required_if:values.valuation-hpi-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'HPI',
                'name' => 'Supplementary product code',
                'config_key' => 'valuation-hpi-supplementary_product_code',
                'type' => 'string',
                'value' => 'HPI25',
                'min_tier' => 'pro',
                'description' => 'Some product codes require a supplementary product code to be specified.'
                    . ' Ensure that the correct codes are used.',
            ],
        ];
    }
}
