<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PhyronImageSyncSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Phyron',
                'name' => 'Enabled',
                'config_key' => 'image-sync-phyron-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Phyron',
                'name' => 'Location of manifest file',
                'config_key' => 'image-sync-phryon-manifest-file',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.image-sync-phyron-enabled,true"
                ]
            ],
        ];
    }
}
