<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use Mtc\MercuryDataModels\Vehicle;

class StockOnSite extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::DEVELOPER;
    }

    public function key(): string
    {
        return 'stock_on_site';
    }

    public function handle(): bool
    {
        $has_stock = Vehicle::query()->active()->count() > 0;
        if (!$has_stock) {
            $this->failure_reason = __('go-live.errors.no-stock-on-site');
            return false;
        }
        return true;
    }
}
