<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SalesforceCrmUrlLengthSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Remove URL parameters from enquiry source page URL',
                'description' => 'To comply with 3rd party URL length restrictions, '
                    . 'remove URL parameters from "?" onwards in enquiry source page URL. '
                    . 'Add the original, unmodified URL in the message body.',
                'config_key' => 'salesforce-crm-remove-url-params',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
