<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\MercuryDataModels\VehicleOffer;

class FixVehicleOffersOrder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:vehicle-offers-order';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix order for vehicle offers - replacing null with actual order value';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $currentMaxOrder = VehicleOffer::max('order') ?? 0;

        $offersToFix = VehicleOffer::query()
            ->whereNull('order')
            ->orderBy('id', 'asc')
            ->get();

        $newOrder = $currentMaxOrder + 1;

        foreach ($offersToFix as $offer) {
            $offer->order = $newOrder++;
            $offer->save();
        }

        $this->info(count($offersToFix) . ' vehicle offers updated with new order values.');
    }
}
