<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CountrySettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Site Details',
            'name' => 'Country',
            'config_key' => 'app-details-country',
            'value' => 'GB',
            'type' => 'string',
            'validation_rules' => 'required',
            'description' => 'Primary country of operation as Alpha-2 code (e.g. GB/IE/DE)',
            'order' => 6,
        ]);
    }

}
