<?php

namespace Tests\Tenant;

use App\Jobs\AssignFilterFeatures;
use Mtc\MercuryDataModels\FilterFeature;
use Mtc\MercuryDataModels\VehicleStandardEquipment;
use Tests\TenantTestCase;

class AssignFilterFeaturesTest extends TenantTestCase
{
    public function testSingleFeature()
    {
        $feature = FilterFeature::factory()->create(['terms' => ['blue', 'white', 'green']]);

        VehicleStandardEquipment::factory(5)->create();
        $blue = VehicleStandardEquipment::factory()->create(['description' => 'blue', 'feature_id' => null]);
        $bluefer = VehicleStandardEquipment::factory()->create(['description' => 'bluefer', 'feature_id' => null]);
        $white = VehicleStandardEquipment::factory()->create(['description' => 'baz white', 'feature_id' => null]);
        $green = VehicleStandardEquipment::factory()->create(['description' => 'bazgreen', 'feature_id' => null]);

        (new AssignFilterFeatures($feature))->handle();

        $this->assertEquals($feature->id, $blue->refresh()->feature_id);
        $this->assertEquals($feature->id, $bluefer->refresh()->feature_id);
        $this->assertEquals($feature->id, $white->refresh()->feature_id);
        $this->assertEquals($feature->id, $green->refresh()->feature_id);
        $this->assertEquals(4, VehicleStandardEquipment::query()->where('feature_id', $feature->id)->count());

    }

    public function testAllFeatures()
    {
        $feature = FilterFeature::factory()->create(['terms' => ['blue', 'green']]);
        $feature2 = FilterFeature::factory()->create(['terms' => ['white']]);

        VehicleStandardEquipment::factory(5)->create();
        $blue = VehicleStandardEquipment::factory()->create(['description' => 'blue', 'feature_id' => null]);
        $bluefer = VehicleStandardEquipment::factory()->create(['description' => 'bluefer', 'feature_id' => null]);
        $white = VehicleStandardEquipment::factory()->create(['description' => 'baz white', 'feature_id' => null]);
        $green = VehicleStandardEquipment::factory()->create(['description' => 'bazgreen', 'feature_id' => null]);

        (new AssignFilterFeatures())->handle();

        $this->assertEquals($feature->id, $blue->refresh()->feature_id);
        $this->assertEquals($feature->id, $bluefer->refresh()->feature_id);
        $this->assertEquals($feature2->id, $white->refresh()->feature_id);
        $this->assertEquals($feature->id, $green->refresh()->feature_id);
        $this->assertEquals(3, VehicleStandardEquipment::query()->where('feature_id', $feature->id)->count());
        $this->assertEquals(1, VehicleStandardEquipment::query()->where('feature_id', $feature2->id)->count());
    }
}
