<?php

namespace Tests\Tenant;

use App\Events\VehicleUpdated;
use App\Jobs\ImportImagesFromUrlList;
use Illuminate\Support\Facades\Event;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TenantTestCase;

class ImportImagesFromUrlListTest extends TenantTestCase
{
    public function testVehicleUpdatedEventDispatched()
    {
        Event::fake();
        $vehicle = Vehicle::factory()->create();
        $offer = VehicleOffer::factory()->create();

        Event::assertDispatchedTimes(VehicleUpdated::class, 0);
        (new ImportImagesFromUrlList(collect(), $vehicle))->handle();
        Event::assertDispatched(VehicleUpdated::class, fn($event) => $event->getVehicle()->id === $vehicle->id);
        Event::assertDispatchedTimes(VehicleUpdated::class, 1);

        (new ImportImagesFromUrlList(collect(), $offer))->handle();
        Event::assertDispatchedTimes(VehicleUpdated::class, 1);
    }
}
