<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdateBillingDetailsRequest;
use App\Http\Requests\UpdateBillingTierRequest;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Tenant;

class BillingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return tenancy()->tenant->billingDetails;
    }

    /**
     * Update Billing details of this site/tenant
     *
     * @param  UpdateBillingDetailsRequest $request
     * @return Model
     */
    public function updateDetails(UpdateBillingDetailsRequest $request)
    {
        /** @var Tenant $tenant */
        $tenant = tenancy()->tenant;
        $tenant->billingDetails()
            ->updateOrCreate([], [
                'vat_rate' => $request->input('vat_rate'),
                'billing_email' => $request->input('billing_email'),
                'contact_no' => $request->input('contact_no'),
                'title' => $request->input('title'),
                'first_name' => $request->input('first_name'),
                'last_name' => $request->input('last_name'),
                'address1' => $request->input('address1'),
                'address2' => $request->input('address2'),
                'city' => $request->input('city'),
                'county' => $request->input('county'),
                'postcode' => $request->input('postcode'),
                'country' => $request->input('country'),
                'state' => $request->input('state'),
            ]);

        return $tenant->billingDetails()->first();
    }

    /**
     * Update tenants tier
     *
     * @param UpdateBillingTierRequest $request
     * @return void
     */
    public function updateSubscription(UpdateBillingTierRequest $request)
    {
        /** @var Tenant $tenant */
        $tenant = tenancy()->tenant;
        $tenant->changeTier($request->input('tier'));
    }
}
